"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeContextMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _common2 = require("@kbn/metrics-data-access-plugin/common");
var _public2 = require("@kbn/metrics-data-access-plugin/public");
var _common3 = require("@kbn/logs-shared-plugin/common");
var _common4 = require("@kbn/observability-plugin/common");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _alert_flyout = require("../../../../../alerting/inventory/components/alert_flyout");
var _get_uptime_url = require("../../lib/get_uptime_url");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeContextMenu = exports.NodeContextMenu = (0, _common.withTheme)(({
  options,
  currentTime,
  node,
  nodeType
}) => {
  var _uiCapabilities$logs, _uiCapabilities$infra;
  const {
    getAssetDetailUrl
  } = (0, _public2.useAssetDetailsRedirect)();
  const [flyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const inventoryModel = (0, _common2.findInventoryModel)(nodeType);
  const nodeDetailFrom = currentTime - inventoryModel.metrics.defaultTimeRangeInSeconds * 1000;
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    application,
    share
  } = services;
  const {
    nodeLogsLocator
  } = (0, _common3.getLogsLocatorsFromUrlService)(share.url);
  const uptimeLocator = share.url.locators.get(_common4.uptimeOverviewLocatorID);
  const uiCapabilities = application === null || application === void 0 ? void 0 : application.capabilities;
  // Due to the changing nature of the fields between APM and this UI,
  // We need to have some exceptions until 7.0 & ECS is finalized. Reference
  // #26620 for the details for these fields.
  // TODO: This is tech debt, remove it after 7.0 & ECS migration.
  const apmField = nodeType === 'host' ? 'host.hostname' : inventoryModel.fields.id;
  const showDetail = inventoryModel.crosslinkSupport.details;
  const showLogsLink = inventoryModel.crosslinkSupport.logs && node.id && (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$logs = uiCapabilities.logs) === null || _uiCapabilities$logs === void 0 ? void 0 : _uiCapabilities$logs.show);
  const showAPMTraceLink = inventoryModel.crosslinkSupport.apm && (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : uiCapabilities.apm) && (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : uiCapabilities.apm.show);
  const showUptimeLink = inventoryModel.crosslinkSupport.uptime && (['pod', 'container'].includes(nodeType) || node.ip) && !!uptimeLocator;
  const showCreateAlertLink = uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra = uiCapabilities.infrastructure) === null || _uiCapabilities$infra === void 0 ? void 0 : _uiCapabilities$infra.save;
  const inventoryId = (0, _react.useMemo)(() => {
    if (nodeType === 'host') {
      if (node.ip) {
        return {
          label: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.infra.inventoryId.host.ipCodeLabel', {
            defaultMessage: 'host.ip'
          })),
          value: node.ip
        };
      }
    } else {
      const {
        id
      } = (0, _common2.findInventoryFields)(nodeType);
      return {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, id),
        value: node.id
      };
    }
    return {
      label: '',
      value: ''
    };
  }, [nodeType, node.ip, node.id]);
  const nodeDetailMenuItemLinkProps = getAssetDetailUrl({
    assetType: nodeType,
    assetId: node.id,
    search: {
      from: nodeDetailFrom,
      to: currentTime,
      name: node.name
    }
  });
  const apmTracesMenuItemLinkProps = (0, _public.useLinkProps)({
    app: 'apm',
    hash: 'traces',
    search: {
      kuery: `${apmField}:"${node.id}"`
    }
  });
  const uptimeMenuItemLinkUrl = showUptimeLink ? (0, _get_uptime_url.getUptimeUrl)({
    uptimeLocator,
    nodeType,
    node
  }) : '';
  const nodeLogsMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewLogsName', {
      defaultMessage: '{inventoryName} logs',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    href: nodeLogsLocator.getRedirectUrl({
      nodeField: (0, _common2.findInventoryFields)(nodeType).id,
      nodeId: node.id,
      time: currentTime
    }),
    'data-test-subj': 'viewLogsContextMenuItem'
  };
  const nodeDetailMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewMetricsName', {
      defaultMessage: '{inventoryName} metrics',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    href: nodeDetailMenuItemLinkProps.href
  };
  const apmTracesMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewAPMTraces', {
      defaultMessage: '{inventoryName} APM traces',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    ...apmTracesMenuItemLinkProps,
    'data-test-subj': 'viewApmTracesContextMenuItem'
  };
  const uptimeMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewUptimeLink', {
      defaultMessage: '{inventoryName} in Uptime',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    href: uptimeMenuItemLinkUrl
  };
  const createAlertMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.createRuleLink', {
      defaultMessage: 'Create inventory rule'
    }),
    onClick: () => {
      setFlyoutVisible(true);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: 300
    },
    "data-test-subj": "nodeContextMenu"
  }, /*#__PURE__*/_react.default.createElement(_public.Section, null, /*#__PURE__*/_react.default.createElement(_public.SectionTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeContextMenu.title",
    defaultMessage: "{inventoryName} details",
    values: {
      inventoryName: inventoryModel.singularDisplayName
    }
  })), inventoryId.label && /*#__PURE__*/_react.default.createElement(_public.SectionSubtitle, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      wordBreak: 'break-all'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeContextMenu.description",
    defaultMessage: "View details for {label} {value}",
    values: {
      label: inventoryId.label,
      value: inventoryId.value
    }
  }))), /*#__PURE__*/_react.default.createElement(_public.SectionLinks, null, showLogsLink && /*#__PURE__*/_react.default.createElement(_public.SectionLink, (0, _extends2.default)({
    "data-test-subj": "viewLogsContextMenuItem"
  }, nodeLogsMenuItem)), showDetail && /*#__PURE__*/_react.default.createElement(_public.SectionLink, (0, _extends2.default)({
    "data-test-subj": "viewAssetDetailsContextMenuItem"
  }, nodeDetailMenuItem)), showAPMTraceLink && /*#__PURE__*/_react.default.createElement(_public.SectionLink, (0, _extends2.default)({
    "data-test-subj": "viewApmTracesContextMenuItem"
  }, apmTracesMenuItem)), showUptimeLink && /*#__PURE__*/_react.default.createElement(_public.SectionLink, (0, _extends2.default)({
    "data-test-subj": "viewApmUptimeContextMenuItem"
  }, uptimeMenuItem, {
    color: 'primary'
  }))), /*#__PURE__*/_react.default.createElement(_public.ActionMenuDivider, null), showCreateAlertLink && /*#__PURE__*/_react.default.createElement(_public.SectionLinks, null, /*#__PURE__*/_react.default.createElement(_public.SectionLink, (0, _extends2.default)({
    iconType: 'bell',
    color: 'primary'
  }, createAlertMenuItem))))), flyoutVisible && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    filter: `${(0, _common2.findInventoryFields)(nodeType).id}: "${node.id}"`,
    options: options,
    nodeType: nodeType,
    setVisible: setFlyoutVisible,
    visible: flyoutVisible
  }));
});