"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Map = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _nodes_to_wafflemap = require("../../lib/nodes_to_wafflemap");
var _type_guards = require("../../lib/type_guards");
var _auto_sizer = require("../../../../../components/auto_sizer");
var _group_of_groups = require("./group_of_groups");
var _group_of_nodes = require("./group_of_nodes");
var _apply_wafflemap_layout = require("../../lib/apply_wafflemap_layout");
var _sort_nodes = require("../../lib/sort_nodes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Map = ({
  nodes,
  options,
  currentTime,
  onFilter,
  formatter,
  bounds,
  nodeType,
  bottomMargin,
  staticHeight,
  detailsItemId
}) => {
  const sortedNodes = (0, _sort_nodes.sortNodes)(options.sort, nodes);
  const map = (0, _nodes_to_wafflemap.nodesToWaffleMap)(sortedNodes);
  return /*#__PURE__*/_react.default.createElement(_auto_sizer.AutoSizer, {
    bounds: true
  }, ({
    measureRef,
    bounds: {
      width = 0,
      height = 0
    }
  }) => {
    const groupsWithLayout = (0, _apply_wafflemap_layout.applyWaffleMapLayout)(map, width, height);
    return /*#__PURE__*/_react.default.createElement(WaffleMapOuterContainer, {
      ref: el => measureRef(el),
      bottomMargin: bottomMargin,
      "data-test-subj": "waffleMap",
      staticHeight: staticHeight
    }, /*#__PURE__*/_react.default.createElement(WaffleMapInnerContainer, null, groupsWithLayout.map(group => {
      if ((0, _type_guards.isWaffleMapGroupWithGroups)(group)) {
        return /*#__PURE__*/_react.default.createElement(_group_of_groups.GroupOfGroups, {
          onDrilldown: onFilter,
          key: group.id,
          options: options,
          group: group,
          formatter: formatter,
          bounds: bounds,
          nodeType: nodeType,
          currentTime: currentTime,
          detailsItemId: detailsItemId
        });
      }
      if ((0, _type_guards.isWaffleMapGroupWithNodes)(group)) {
        return /*#__PURE__*/_react.default.createElement(_group_of_nodes.GroupOfNodes, {
          key: group.id,
          options: options,
          group: group,
          onDrilldown: onFilter,
          formatter: formatter,
          isChild: false,
          bounds: bounds,
          nodeType: nodeType,
          currentTime: currentTime,
          detailsItemId: detailsItemId
        });
      }
    })));
  });
};
exports.Map = Map;
const WaffleMapOuterContainer = _common.euiStyled.div`
  flex: 1 0 0%;
  display: flex;
  justify-content: flex-start;
  flex-direction: column;
  overflow-x: hidden;
  overflow-y: auto;
  margin-bottom: ${props => props.bottomMargin}px;
  max-width: calc(100vw - 90px);
  ${props => props.staticHeight && 'min-height: 300px;'}
`;
const WaffleMapInnerContainer = _common.euiStyled.div`
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
  justify-content: center;
  align-content: flex-start;
`;