"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricChartWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _chart_placeholder = require("../../../../../components/lens/chart_placeholder");
var _use_kibana = require("../../../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricChartWrapper = exports.MetricChartWrapper = /*#__PURE__*/_react.default.memo(({
  color,
  extra,
  id,
  loading,
  value,
  subtitle,
  title,
  toolTip,
  style,
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const loadedOnce = (0, _react.useRef)(false);
  const {
    services: {
      charts
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  (0, _react.useEffect)(() => {
    if (!loadedOnce.current && !loading) {
      loadedOnce.current = true;
    }
  }, [loading]);
  const metricsData = {
    title,
    subtitle,
    color,
    extra,
    value,
    valueFormatter: d => d.toString()
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({}, props, {
    hasShadow: false,
    paddingSize: "none",
    "data-test-subj": id,
    css: (0, _react2.css)`
          display: flex;
          position: relative;
        `
  }), loading && !loadedOnce.current ? /*#__PURE__*/_react.default.createElement(_chart_placeholder.ChartPlaceholder, {
    style: style
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: "eui-fullWidth",
    delay: "regular",
    content: toolTip,
    anchorClassName: "eui-fullWidth"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: style,
    css: (0, _react2.css)`
                .echMetric {
                  border-radius: ${euiTheme.border.radius.medium};
                  pointer-events: none;
                }
              `
  }, loading && /*#__PURE__*/_react.default.createElement(_chart_placeholder.ChartLoadingProgress, {
    hasTopMargin: false
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: id,
    data: [[metricsData]]
  }))));
});