"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStringInputFieldProps = exports.getInputFieldProps = exports.getFormRowProps = void 0;
var _react = _interopRequireDefault(require("react"));
var _source_configuration_form_errors = require("./source_configuration_form_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormRowProps = formElement => ({
  error: formElement.validity.validity === 'invalid' ? formElement.validity.reasons.map(error => /*#__PURE__*/_react.default.createElement(_source_configuration_form_errors.LogSourceConfigurationFormError, {
    error: error
  })) : [],
  isInvalid: formElement.validity.validity === 'invalid'
});
exports.getFormRowProps = getFormRowProps;
const getInputFieldProps = (decodeInputValue, encodeInputValue) => formElement => ({
  isInvalid: formElement.validity.validity === 'invalid',
  onChange: evt => {
    const newValue = evt.currentTarget.value;
    formElement.updateValue(() => decodeInputValue(newValue));
  },
  value: encodeInputValue(formElement.value)
});
exports.getInputFieldProps = getInputFieldProps;
const getStringInputFieldProps = exports.getStringInputFieldProps = getInputFieldProps(value => `${value}`, value => value);