"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exampleTimestampFormat = exports.exampleMessageScale = exports.exampleMessageColumnConfigurations = exports.columnWidths = exports.LogEntryExampleMessageHeaders = exports.LogEntryExampleMessage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _rison = require("@kbn/rison");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ml-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _public3 = require("@kbn/logs-shared-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _log_analysis = require("../../../../../../common/log_analysis");
var _job_parameters = require("../../../../../../common/log_analysis/job_parameters");
var _source_configuration = require("../../../../../utils/source_configuration");
var _datetime = require("../../../../../../common/formatters/datetime");
var _log_flyout = require("../../../../../containers/logs/log_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exampleMessageScale = exports.exampleMessageScale = 'medium';
const exampleTimestampFormat = exports.exampleTimestampFormat = 'time';
const MENU_LABEL = _i18n.i18n.translate('xpack.infra.logAnomalies.logEntryExamplesMenuLabel', {
  defaultMessage: 'View actions for log entry'
});
const VIEW_DETAILS_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewDetailsLabel', {
  defaultMessage: 'View details'
});
const VIEW_IN_STREAM_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewInStreamLabel', {
  defaultMessage: 'View in stream'
});
const VIEW_ANOMALY_IN_ML_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewAnomalyInMlLabel', {
  defaultMessage: 'View anomaly in machine learning'
});
const LogEntryExampleMessage = ({
  id,
  dataset,
  message,
  timestamp,
  tiebreaker,
  timeRange,
  anomaly
}) => {
  const {
    services: {
      ml,
      http,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [isHovered, setIsHovered] = (0, _react.useState)(false);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const openMenu = (0, _react.useCallback)(() => setIsMenuOpen(true), []);
  const closeMenu = (0, _react.useCallback)(() => setIsMenuOpen(false), []);
  const setItemIsHovered = (0, _react.useCallback)(() => setIsHovered(true), []);
  const setItemIsNotHovered = (0, _react.useCallback)(() => setIsHovered(false), []);
  const {
    openFlyout: openLogEntryFlyout
  } = (0, _log_flyout.useLogEntryFlyoutContext)();

  // handle special cases for the dataset value
  const humanFriendlyDataset = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset);
  const time = (0, _moment.default)(timestamp).toISOString();
  const viewInStreamLinkProps = (0, _public2.useLinkProps)({
    app: 'logs',
    pathname: 'stream',
    search: {
      logPosition: (0, _rison.encode)({
        end: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        position: {
          tiebreaker,
          time
        },
        start: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        streamLive: false
      }),
      flyoutOptions: (0, _rison.encode)({
        surroundingLogsId: id
      }),
      ...(dataset ? {
        logFilter: (0, _rison.encode)({
          expression: `${_job_parameters.partitionField}: ${dataset}`,
          kind: 'kuery'
        })
      } : {})
    }
  });
  const viewAnomalyInMachineLearningLink = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: _public.ML_PAGES.SINGLE_METRIC_VIEWER,
    pageState: {
      jobIds: [anomaly.jobId],
      timeRange: {
        from: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        to: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        mode: 'absolute'
      },
      entities: {
        [_job_parameters.partitionField]: dataset,
        ...((0, _log_analysis.isCategoryAnomaly)(anomaly) ? {
          mlcategory: anomaly.categoryId
        } : {})
      }
    }
  });
  const handleMlLinkClick = (0, _react.useCallback)(e => {
    if (!viewAnomalyInMachineLearningLink || !(0, _public2.shouldHandleLinkEvent)(e)) return;
    application.navigateToUrl(viewAnomalyInMachineLearningLink);
  }, [viewAnomalyInMachineLearningLink, application]);
  const menuItems = (0, _react.useMemo)(() => {
    if (!viewInStreamLinkProps.onClick || !viewAnomalyInMachineLearningLink) {
      return undefined;
    }
    return [{
      label: VIEW_DETAILS_LABEL,
      onClick: () => {
        openLogEntryFlyout(id);
      }
    }, {
      label: VIEW_IN_STREAM_LABEL,
      onClick: viewInStreamLinkProps.onClick,
      href: viewInStreamLinkProps.href
    }, {
      label: VIEW_ANOMALY_IN_ML_LABEL,
      onClick: handleMlLinkClick,
      href: viewAnomalyInMachineLearningLink
    }];
  }, [id, openLogEntryFlyout, viewInStreamLinkProps, viewAnomalyInMachineLearningLink, handleMlLinkClick]);
  return /*#__PURE__*/_react.default.createElement(_public3.LogEntryRowWrapper, {
    scale: exampleMessageScale,
    onMouseEnter: setItemIsHovered,
    onMouseLeave: setItemIsNotHovered
  }, /*#__PURE__*/_react.default.createElement(_public3.LogEntryColumn, columnWidths[timestampColumnId], /*#__PURE__*/_react.default.createElement(_public3.LogEntryTimestampColumn, {
    format: exampleTimestampFormat,
    time: time
  })), /*#__PURE__*/_react.default.createElement(_public3.LogEntryColumn, columnWidths[messageColumnId], /*#__PURE__*/_react.default.createElement(_public3.LogEntryMessageColumn, {
    columnValue: {
      columnId: messageColumnId,
      message: [{
        field: 'message',
        value: [message],
        highlights: []
      }]
    },
    highlights: noHighlights,
    isActiveHighlight: false,
    wrapMode: "none"
  })), /*#__PURE__*/_react.default.createElement(_public3.LogEntryColumn, columnWidths[datasetColumnId], /*#__PURE__*/_react.default.createElement(_public3.LogEntryFieldColumn, {
    columnValue: {
      columnId: datasetColumnId,
      field: 'event.dataset',
      value: [humanFriendlyDataset],
      highlights: []
    },
    highlights: noHighlights,
    isActiveHighlight: false,
    wrapMode: "none"
  })), /*#__PURE__*/_react.default.createElement(_public3.LogEntryColumn, (0, _extends2.default)({
    key: "logColumn iconLogColumn iconLogColumn:details"
  }, columnWidths[_public3.iconColumnId]), (isHovered || isMenuOpen) && menuItems ? /*#__PURE__*/_react.default.createElement(_public3.LogEntryContextMenu, {
    "aria-label": MENU_LABEL,
    isOpen: isMenuOpen,
    onOpen: openMenu,
    onClose: closeMenu,
    items: menuItems
  }) : null));
};
exports.LogEntryExampleMessage = LogEntryExampleMessage;
const noHighlights = [];
const timestampColumnId = 'log-entry-example-timestamp-column';
const messageColumnId = 'log-entry-examples-message-column';
const datasetColumnId = 'log-entry-examples-dataset-column';
const DETAIL_FLYOUT_ICON_MIN_WIDTH = 32;
const COLUMN_PADDING = 8;
const columnWidths = exports.columnWidths = {
  [timestampColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    // w_score - w_padding = 130 px  - 8 px
    baseWidth: '122px'
  },
  [messageColumnId]: {
    growWeight: 1,
    shrinkWeight: 0,
    baseWidth: '0%'
  },
  [datasetColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    baseWidth: '250px'
  },
  [_public3.iconColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    baseWidth: `${DETAIL_FLYOUT_ICON_MIN_WIDTH + 2 * COLUMN_PADDING}px`
  }
};
const exampleMessageColumnConfigurations = exports.exampleMessageColumnConfigurations = [{
  timestampColumn: {
    id: timestampColumnId
  }
}, {
  messageColumn: {
    id: messageColumnId
  }
}, {
  fieldColumn: {
    field: 'event.dataset',
    id: datasetColumnId
  }
}];
const LogEntryExampleMessageHeaders = ({
  dateTime
}) => {
  return /*#__PURE__*/_react.default.createElement(LogEntryExampleMessageHeadersWrapper, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, exampleMessageColumnConfigurations.map(columnConfiguration => {
    if ((0, _source_configuration.isTimestampLogColumnConfiguration)(columnConfiguration)) {
      return /*#__PURE__*/_react.default.createElement(_public3.LogColumnHeader, {
        key: columnConfiguration.timestampColumn.id,
        columnWidth: columnWidths[columnConfiguration.timestampColumn.id],
        "data-test-subj": "logColumnHeader timestampLogColumnHeader"
      }, (0, _datetime.localizedDate)(dateTime));
    } else if ((0, _source_configuration.isMessageLogColumnConfiguration)(columnConfiguration)) {
      return /*#__PURE__*/_react.default.createElement(_public3.LogColumnHeader, {
        columnWidth: columnWidths[columnConfiguration.messageColumn.id],
        "data-test-subj": "logColumnHeader messageLogColumnHeader",
        key: columnConfiguration.messageColumn.id
      }, _i18n.i18n.translate('xpack.infra.logEntryExampleMessageHeaders.logColumnHeader.messageLabel', {
        defaultMessage: 'Message'
      }));
    } else if ((0, _source_configuration.isFieldLogColumnConfiguration)(columnConfiguration)) {
      return /*#__PURE__*/_react.default.createElement(_public3.LogColumnHeader, {
        columnWidth: columnWidths[columnConfiguration.fieldColumn.id],
        "data-test-subj": "logColumnHeader fieldLogColumnHeader",
        key: columnConfiguration.fieldColumn.id
      }, columnConfiguration.fieldColumn.field);
    }
  }), /*#__PURE__*/_react.default.createElement(_public3.LogColumnHeader, {
    columnWidth: columnWidths[_public3.iconColumnId],
    "data-test-subj": "logColumnHeader contextMenuLogColumnHeader",
    key: 'icon-column-header'
  }, null)));
};
exports.LogEntryExampleMessageHeaders = LogEntryExampleMessageHeaders;
const LogEntryExampleMessageHeadersWrapper = (0, _common.euiStyled)(_public3.LogColumnHeadersWrapper)`
  border-bottom: none;
  box-shadow: none;
  padding-right: 0;
`;