"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesResults = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _anomalies_swimlane_visualisation = require("./anomalies_swimlane_visualisation");
var _table = require("./table");
var _loading_overlay_wrapper = require("../../../../../components/loading_overlay_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomaliesResults = ({
  isLoadingAnomaliesResults,
  timeRange,
  anomalies,
  changeSortOptions,
  sortOptions,
  changePaginationOptions,
  paginationOptions,
  fetchNextPage,
  fetchPreviousPage,
  page,
  selectedDatasets,
  jobIds,
  autoRefresh
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_anomalies_swimlane_visualisation.AnomaliesSwimlaneVisualisation, {
    jobIds: jobIds,
    timeRange: timeRange,
    selectedDatasets: selectedDatasets,
    autoRefresh: autoRefresh
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !anomalies || anomalies.length === 0 ? /*#__PURE__*/_react.default.createElement(_loading_overlay_wrapper.LoadingOverlayWrapper, {
    isLoading: isLoadingAnomaliesResults,
    loadingChildren: /*#__PURE__*/_react.default.createElement(LoadingOverlayContent, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.logs.analysis.anomalySectionNoDataTitle', {
      defaultMessage: 'There is no data to display.'
    })),
    titleSize: "m",
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.logs.analysis.anomalySectionNoDataBody', {
      defaultMessage: 'You may want to adjust your time range.'
    }))
  })) : /*#__PURE__*/_react.default.createElement(_table.AnomaliesTable, {
    results: anomalies,
    timeRange: timeRange,
    changeSortOptions: changeSortOptions,
    changePaginationOptions: changePaginationOptions,
    sortOptions: sortOptions,
    paginationOptions: paginationOptions,
    fetchNextPage: fetchNextPage,
    fetchPreviousPage: fetchPreviousPage,
    page: page,
    isLoading: isLoadingAnomaliesResults
  })));
};
exports.AnomaliesResults = AnomaliesResults;
const loadingAriaLabel = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesSectionLoadingAriaLabel', {
  defaultMessage: 'Loading anomalies'
});
const LoadingOverlayContent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xl",
  "aria-label": loadingAriaLabel
});