"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToInventory = void 0;
var _react = require("react");
var _queryString = require("query-string");
var _common = require("@kbn/observability-shared-plugin/common");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToInventory = ({
  location
}) => {
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const baseLocator = share.url.locators.get(_common.INVENTORY_LOCATOR_ID);
  (0, _react.useEffect)(() => {
    var _parsedQueryString$ti;
    const parsedQueryString = (0, _queryString.parse)(location.search || '', {
      sort: false
    });
    const currentTime = parseFloat((_parsedQueryString$ti = parsedQueryString.timestamp) !== null && _parsedQueryString$ti !== void 0 ? _parsedQueryString$ti : '');
    baseLocator === null || baseLocator === void 0 ? void 0 : baseLocator.navigate({
      ...parsedQueryString,
      waffleTime: {
        currentTime,
        isAutoReloading: false
      },
      state: location.state
    });
  }, [baseLocator, location.search, location.state]);
  return null;
};
exports.RedirectToInventory = RedirectToInventory;