"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToLogsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _redirect_to_logs = require("./redirect_to_logs");
var _redirect_to_node_logs = require("./redirect_to_node_logs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ITEM_TYPES = _common.inventoryModels.map(m => m.id).join('|');

/**
 * @deprecated Link-to routes shouldn't be used anymore
 * Instead please use locators registered for the infra plugin
 * LogsLocator & NodeLogsLocator
 */
const LinkToLogsPage = props => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${props.match.url}/:logViewId?/:nodeType(${ITEM_TYPES})-logs/:nodeId`,
    component: _redirect_to_node_logs.RedirectToNodeLogs
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${props.match.url}/:logViewId?/logs`,
    component: _redirect_to_logs.RedirectToLogs
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${props.match.url}/:logViewId?`,
    component: _redirect_to_logs.RedirectToLogs
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/"
  }));
};
exports.LinkToLogsPage = LinkToLogsPage;