"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateQueryInSearchBar = exports.updateFiltersInSearchBar = exports.subscribeToQuerySearchBarChanges = exports.subscribeToFilterSearchBarChanges = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const subscribeToQuerySearchBarChanges = ({
  queryStringService
}) => context => queryStringService.getUpdates$().pipe((0, _rxjs.map)(() => queryStringService.getQuery()), (0, _rxjs.map)(query => {
  return {
    type: 'QUERY_FROM_SEARCH_BAR_CHANGED',
    query
  };
}));
exports.subscribeToQuerySearchBarChanges = subscribeToQuerySearchBarChanges;
const updateQueryInSearchBar = ({
  queryStringService
}) => (context, event) => {
  if ('query' in context) {
    queryStringService.setQuery(context.query);
  }
};
exports.updateQueryInSearchBar = updateQueryInSearchBar;
const subscribeToFilterSearchBarChanges = ({
  filterManagerService
}) => context => filterManagerService.getUpdates$().pipe((0, _rxjs.map)(() => filterManagerService.getFilters()), (0, _rxjs.map)(filters => {
  return {
    type: 'FILTERS_FROM_SEARCH_BAR_CHANGED',
    filters
  };
}));
exports.subscribeToFilterSearchBarChanges = subscribeToFilterSearchBarChanges;
const updateFiltersInSearchBar = ({
  filterManagerService
}) => (context, event) => {
  if ('filters' in context) {
    filterManagerService.setFilters(context.filters);
  }
};
exports.updateFiltersInSearchBar = updateFiltersInSearchBar;