"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateContextInUrl = exports.positionStateInUrlRT = exports.initializeFromUrl = exports.defaultPositionStateKey = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _public = require("@kbn/kibana-utils-plugin/public");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _function = require("fp-ts/lib/function");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _time = require("../../../../common/time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultPositionStateKey = exports.defaultPositionStateKey = 'logPosition';
const updateContextInUrl = ({
  urlStateStorage,
  positionStateKey = defaultPositionStateKey
}) => (context, _event) => {
  if (!('latestPosition' in context)) {
    throw new Error('Missing keys from context needed to sync to the URL');
  }
  urlStateStorage.set(positionStateKey, positionStateInUrlRT.encode({
    position: context.latestPosition ? (0, _time.pickTimeKey)(context.latestPosition) : null
  }), {
    replace: true
  });
};
exports.updateContextInUrl = updateContextInUrl;
const initializeFromUrl = ({
  positionStateKey = defaultPositionStateKey,
  urlStateStorage,
  toastsService
}) => (_context, _event) => send => {
  var _urlStateStorage$get;
  const positionQueryValueFromUrl = (_urlStateStorage$get = urlStateStorage.get(positionStateKey)) !== null && _urlStateStorage$get !== void 0 ? _urlStateStorage$get : {};
  const initialUrlValues = (0, _function.pipe)(decodePositionQueryValueFromUrl(positionQueryValueFromUrl), Either.map(({
    position
  }) => {
    var _position$tiebreaker;
    return {
      targetPosition: position !== null && position !== void 0 && position.time ? {
        time: position.time,
        tiebreaker: (_position$tiebreaker = position.tiebreaker) !== null && _position$tiebreaker !== void 0 ? _position$tiebreaker : 0
      } : null
    };
  }), Either.map(({
    targetPosition
  }) => ({
    targetPosition,
    latestPosition: targetPosition
  })));
  if (Either.isLeft(initialUrlValues)) {
    (0, _public.withNotifyOnErrors)(toastsService).onGetError((0, _ioTsUtils.createPlainError)((0, _ioTsUtils.formatErrors)(initialUrlValues.left)));
    send({
      type: 'INITIALIZED_FROM_URL',
      targetPosition: null,
      latestPosition: null
    });
  } else {
    var _initialUrlValues$rig, _initialUrlValues$rig2;
    send({
      type: 'INITIALIZED_FROM_URL',
      targetPosition: (_initialUrlValues$rig = initialUrlValues.right.targetPosition) !== null && _initialUrlValues$rig !== void 0 ? _initialUrlValues$rig : null,
      latestPosition: (_initialUrlValues$rig2 = initialUrlValues.right.latestPosition) !== null && _initialUrlValues$rig2 !== void 0 ? _initialUrlValues$rig2 : null
    });
  }
};
exports.initializeFromUrl = initializeFromUrl;
const positionStateInUrlRT = exports.positionStateInUrlRT = rt.partial({
  position: rt.union([rt.partial(_time.minimalTimeKeyRT.props), rt.null])
});
const decodePositionQueryValueFromUrl = queryValueFromUrl => {
  return positionStateInUrlRT.decode(queryValueFromUrl);
};