"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamPositionNotificationEventSelectors = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogStreamPositionNotificationEventSelectors = exports.LogStreamPositionNotificationEventSelectors = {
  positionsChanged: context => {
    return 'targetPosition' in context && 'latestPosition' in context && 'visiblePositions' in context ? {
      type: 'POSITIONS_CHANGED',
      targetPosition: context.targetPosition,
      latestPosition: context.latestPosition,
      visiblePositions: context.visiblePositions
    } : undefined;
  },
  pageEndBufferReached: context => ({
    type: 'PAGE_END_BUFFER_REACHED'
  })
};