"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReloadRequestTimeContext = exports.useReloadRequestTime = exports.ReloadRequestTimeProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useReloadRequestTime = () => {
  const [reloadRequestTime, setReloadRequestTime] = (0, _react.useState)(Date.now());
  const updateReloadRequestTime = (0, _react.useCallback)(() => {
    setReloadRequestTime(Date.now());
  }, []);
  return {
    updateReloadRequestTime,
    reloadRequestTime
  };
};
exports.useReloadRequestTime = useReloadRequestTime;
const [ReloadRequestTimeProvider, useReloadRequestTimeContext] = (0, _constate.default)(useReloadRequestTime);
exports.useReloadRequestTimeContext = useReloadRequestTimeContext;
exports.ReloadRequestTimeProvider = ReloadRequestTimeProvider;