"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityCentricExperienceSetting = useEntityCentricExperienceSetting;
var _common = require("@kbn/observability-plugin/common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useEntityCentricExperienceSetting() {
  const {
    uiSettings
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const isEntityCentricExperienceEnabled = uiSettings.get(_common.entityCentricExperience);
  return {
    isEntityCentricExperienceEnabled
  };
}