"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogSearchInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _Class;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogSearchInput = exports.LogSearchInput = (_Class = class LogSearchInput extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      query: ''
    });
    (0, _defineProperty2.default)(this, "handleSubmit", evt => {
      evt.preventDefault();
      const {
        query
      } = this.state;
      if (query === '') {
        this.props.onClear();
      } else {
        this.props.onSearch(this.state.query);
      }
    });
    (0, _defineProperty2.default)(this, "handleChangeQuery", evt => {
      this.setState({
        query: evt.target.value
      });
    });
  }
  render() {
    const {
      className,
      isLoading
    } = this.props;
    const {
      query
    } = this.state;
    const classes = (0, _classnames.default)('loggingSearchInput', className);
    return /*#__PURE__*/React.createElement("form", {
      onSubmit: this.handleSubmit
    }, /*#__PURE__*/React.createElement(PlainSearchField, {
      "aria-label": _i18n.i18n.translate('xpack.infra.logs.search.searchInLogsAriaLabel', {
        defaultMessage: 'search'
      }),
      className: classes,
      fullWidth: true,
      isLoading: isLoading,
      onChange: this.handleChangeQuery,
      placeholder: _i18n.i18n.translate('xpack.infra.logs.search.searchInLogsPlaceholder', {
        defaultMessage: 'Search'
      }),
      value: query
    }));
  }
}, (0, _defineProperty2.default)(_Class, "displayName", 'LogSearchInput'), _Class);
const PlainSearchField = (0, _common.euiStyled)(_eui.EuiFieldSearch)`
  background: transparent;
  box-shadow: none;

  &:focus {
    box-shadow: inset 0 -2px 0 0 ${props => props.theme.eui.euiColorPrimary};
  }
`;