"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryExampleMessagesFailureIndicator = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryExampleMessagesFailureIndicator = ({
  onRetry
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  className: "eui-textNoWrap"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "danger"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.logEntryExamples.exampleLoadingFailureDescription",
  defaultMessage: "Failed to load examples."
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  "data-test-subj": "infraLogEntryExampleMessagesFailureIndicatorRetryButton",
  onClick: onRetry,
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.logEntryExamples.exampleLoadingFailureRetryButtonLabel",
  defaultMessage: "Retry"
}))));
exports.LogEntryExampleMessagesFailureIndicator = LogEntryExampleMessagesFailureIndicator;