"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisModuleListCard = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _create_job_button = require("../create_job_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogAnalysisModuleListCard = ({
  jobId,
  hasSetupCapabilities,
  moduleDescription,
  moduleName,
  moduleStatus,
  onViewSetup
}) => {
  const {
    services: {
      ml,
      application: {
        navigateToUrl
      },
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [viewInMlLink, setViewInMlLink] = (0, _react.useState)('');
  const getMlUrl = async () => {
    if (!(ml !== null && ml !== void 0 && ml.locator)) {
      toasts.addWarning({
        title: mlNotAvailableMessage
      });
      return;
    }
    setViewInMlLink(await ml.locator.getUrl({
      page: 'jobs',
      pageState: {
        jobId
      }
    }));
  };
  (0, _react.useEffect)(() => {
    getMlUrl();
  });
  const navigateToMlApp = async () => {
    await navigateToUrl(viewInMlLink);
  };
  const moduleIcon = moduleStatus.type === 'required' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: "machineLearningApp"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "success",
    size: "xxl",
    type: "check"
  });
  const moduleSetupButton = moduleStatus.type === 'required' ? /*#__PURE__*/_react.default.createElement(_create_job_button.CreateJobButton, {
    hasSetupCapabilities: hasSetupCapabilities,
    onClick: onViewSetup
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.enableAnomalyDetectionButtonLabel",
    defaultMessage: "Enable anomaly detection"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_create_job_button.RecreateJobButton, {
    hasSetupCapabilities: hasSetupCapabilities,
    onClick: onViewSetup
  }), viewInMlLink ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraLogAnalysisModuleListCardViewInMachineLearningButton",
    onClick: navigateToMlApp
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.viewInMlButtonLabel",
    defaultMessage: "View in Machine Learning"
  }))) : null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    description: moduleDescription,
    footer: /*#__PURE__*/_react.default.createElement("div", null, moduleSetupButton),
    icon: moduleIcon,
    title: moduleName
  });
};
exports.LogAnalysisModuleListCard = LogAnalysisModuleListCard;
const mlNotAvailableMessage = _i18n.i18n.translate('xpack.infra.logs.analysis.mlNotAvailable', {
  defaultMessage: 'ML plugin is not available'
});