"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContainerMetricsExplanationContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/visualizations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContainerMetricsExplanationContent = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.containerViewPage.metricsExplanation",
    defaultMessage: "Showing metrics for your container(s)"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "containerViewMetricsDocumentationLink",
    href: _constants.CONTAINER_METRICS_DOC_HREF,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.infra.containerViewPage.tooltip.whatAreTheseMetricsLink', {
    defaultMessage: 'What are these metrics?'
  })))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "containerViewMetricsDocumentationLink",
    href: _constants.HOST_METRICS_DOTTED_LINES_DOC_HREF,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.infra.hostsViewPage.tooltip.whyAmISeeingDottedLines', {
    defaultMessage: 'Why am I seeing dotted lines?'
  })))));
};
exports.ContainerMetricsExplanationContent = ContainerMetricsExplanationContent;