"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpCenterContent = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpCenterContent = ({
  feedbackLink,
  appName
}) => {
  const chrome = (0, _public.useKibana)().services.chrome;
  (0, _react.useEffect)(() => {
    return chrome === null || chrome === void 0 ? void 0 : chrome.setHelpExtension({
      appName,
      links: [{
        linkType: 'discuss',
        href: feedbackLink
      }]
    });
  }, [feedbackLink, appName, chrome]);
  return null;
};
exports.HelpCenterContent = HelpCenterContent;