"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toolbar = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The return type of this component needs to be specified because the inferred
// return type depends on types that are not exported from EUI. You get a TS4023
// error if the return type is not specified.
const Toolbar = exports.Toolbar = (0, _common.euiStyled)(_eui.EuiPanel).attrs(() => ({
  grow: false,
  paddingSize: 'none'
}))`
  border-top: none;
  border-right: none;
  border-left: none;
  border-radius: 0;
  padding: ${props => props.theme.eui.euiSizeS} ${props => props.theme.eui.euiSizeL};
`;