"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toTimestampRange = exports.getIntegrationsAvailable = exports.getDefaultDateRange = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toTimestampRange = ({
  from,
  to
}) => {
  const fromTs = new Date(from).getTime();
  const toTs = new Date(to).getTime();
  return {
    from: fromTs,
    to: toTs
  };
};
exports.toTimestampRange = toTimestampRange;
const DEFAULT_FROM_IN_MILLISECONDS = 15 * 60000;
const getDefaultDateRange = () => {
  const now = Date.now();
  return {
    from: new Date(now - DEFAULT_FROM_IN_MILLISECONDS).toISOString(),
    to: new Date(now).toISOString()
  };
};
exports.getDefaultDateRange = getDefaultDateRange;
const getIntegrationsAvailable = metadata => {
  if (!metadata) {
    return [];
  }
  return Object.entries(_constants.INTEGRATIONS).filter(([_, fields]) => {
    var _metadata$features;
    return metadata === null || metadata === void 0 ? void 0 : (_metadata$features = metadata.features) === null || _metadata$features === void 0 ? void 0 : _metadata$features.some(f => fields.includes(f.name));
  }).map(([name]) => name);
};
exports.getIntegrationsAvailable = getIntegrationsAvailable;