"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorPrompt = ErrorPrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorPrompt() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "warning",
    iconType: "warning",
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.profiling.loadErrorTitle', {
      defaultMessage: 'Unable to load the Profiling data'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.profiling.loadErrorBody', {
      defaultMessage: 'There was an error while trying to load profiling data. Try refreshing the page'
    }))
  });
}