"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkDashboard = LinkDashboard;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _save_dashboard_modal = require("./save_dashboard_modal");
var _use_saved_objects_permissions = require("../../../hooks/use_saved_objects_permissions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LinkDashboard({
  onRefresh,
  newDashboardButton = false,
  customDashboards,
  assetType
}) {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    canSave
  } = (0, _use_saved_objects_permissions.useSavedObjectUserPermissions)();
  const onClick = (0, _react.useCallback)(() => setIsModalVisible(true), []);
  const onClose = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: !canSave ? /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "infraCannotAddDashboardTooltip"
    }, _i18n.i18n.translate('xpack.infra.linkDashboard.tooltip.youDoNotHavePermissionToUseThisFeature', {
      defaultMessage: 'You do not have permission to use this feature. Please ask your administrator for access.'
    })) : undefined
  }, newDashboardButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "s",
    iconType: "plusInCircle",
    "data-test-subj": "infraLinkDashboardMenu",
    onClick: onClick,
    disabled: !canSave
  }, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.linkNewDashboardButtonLabel', {
    defaultMessage: 'Link new dashboard'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraAddDashboard",
    onClick: onClick,
    disabled: !canSave
  }, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.linkButtonLabel', {
    defaultMessage: 'Link dashboard'
  }))), isModalVisible && /*#__PURE__*/_react.default.createElement(_save_dashboard_modal.SaveDashboardModal, {
    onClose: onClose,
    onRefresh: onRefresh,
    customDashboards: customDashboards,
    assetType: assetType
  }));
}