"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingKuery = useProfilingKuery;
var _react = require("react");
var _constants = require("../../../../common/constants");
var _use_asset_details_render_props = require("./use_asset_details_render_props");
var _use_asset_details_url_state = require("./use_asset_details_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildFullProfilingKuery(assetName, profilingSearch) {
  var _profilingSearch$trim;
  const defaultKuery = `${_constants.HOST_NAME_FIELD} : "${assetName}"`;
  const customKuery = (_profilingSearch$trim = profilingSearch === null || profilingSearch === void 0 ? void 0 : profilingSearch.trim()) !== null && _profilingSearch$trim !== void 0 ? _profilingSearch$trim : '';
  return customKuery !== '' ? `${defaultKuery} and ${customKuery}` : defaultKuery;
}
function useProfilingKuery() {
  var _assetDetailsUrlState;
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const [assetDetailsUrlState, setAssetDetailsUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const [fullKuery, setFullKuery] = (0, _react.useState)(buildFullProfilingKuery(asset.name, assetDetailsUrlState === null || assetDetailsUrlState === void 0 ? void 0 : assetDetailsUrlState.profilingSearch));
  const setCustomKuery = customKuery => {
    setAssetDetailsUrlState({
      profilingSearch: customKuery
    });
    setFullKuery(buildFullProfilingKuery(asset.name, customKuery));
  };
  return {
    fullKuery,
    customKuery: (_assetDetailsUrlState = assetDetailsUrlState === null || assetDetailsUrlState === void 0 ? void 0 : assetDetailsUrlState.profilingSearch) !== null && _assetDetailsUrlState !== void 0 ? _assetDetailsUrlState : '',
    setCustomKuery
  };
}