"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-utils-plugin/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _link_to_logs = require("../pages/link_to/link_to_logs");
var _logs = require("../pages/logs");
var _common_providers = require("./common_providers");
var _common_styles = require("./common_styles");
var _kbn_url_state_context = require("../containers/kbn_url_state_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = (core, plugins, pluginStart, isLogsExplorerAccessible, {
  element,
  history,
  setHeaderActionMenu,
  theme$
}) => {
  const storage = new _public.Storage(window.localStorage);
  (0, _common_styles.prepareMountElement)(element, 'infraLogsPage');
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(LogsApp, {
    core: core,
    storage: storage,
    history: history,
    plugins: plugins,
    pluginStart: pluginStart,
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$,
    isLogsExplorerAccessible: isLogsExplorerAccessible
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
const LogsApp = ({
  core,
  history,
  pluginStart,
  plugins,
  setHeaderActionMenu,
  storage,
  theme$,
  isLogsExplorerAccessible
}) => {
  const {
    logs
  } = core.application.capabilities;
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
    core: core,
    pluginStart: pluginStart,
    plugins: plugins,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_common_providers.CommonInfraProviders, {
    appName: "Logs UI",
    setHeaderActionMenu: setHeaderActionMenu,
    storage: storage,
    theme$: theme$,
    triggersActionsUI: plugins.triggersActionsUi
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_kbn_url_state_context.KbnUrlStateStorageFromRouterProvider, {
    history: history,
    toastsService: core.notifications.toasts
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, isLogsExplorerAccessible && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    exact: true,
    render: () => {
      var _plugins$share$url$lo;
      (_plugins$share$url$lo = plugins.share.url.locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID)) === null || _plugins$share$url$lo === void 0 ? void 0 : _plugins$share$url$lo.navigate({});
      return null;
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/link-to",
    component: _link_to_logs.LinkToLogsPage
  }), (logs === null || logs === void 0 ? void 0 : logs.show) && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    component: _logs.LogsPage
  }))))));
};