"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * uiSettings definitions for the logs_data_access plugin.
 */

const uiSettings = exports.uiSettings = {
  [_managementSettingsIds.OBSERVABILITY_ENABLE_LOGS_STREAM]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.infra.enableLogsStream', {
      defaultMessage: 'Logs Stream'
    }),
    value: false,
    description: _i18n.i18n.translate('xpack.infra.enableLogsStreamDescription', {
      defaultMessage: 'Enables the legacy Logs Stream application and dashboard panel. '
    }),
    deprecation: {
      message: _i18n.i18n.translate('xpack.infra.enableLogsStreamDeprecationWarning', {
        defaultMessage: 'Logs Stream is deprecated, and this setting will be removed in Kibana 9.0.'
      }),
      docLinksKey: 'generalSettings'
    },
    type: 'boolean',
    schema: _configSchema.schema.boolean(),
    requiresPageReload: true
  }
};