"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsExplorerViewResponsePayloadRT = exports.metricsExplorerViewRequestQueryRT = exports.metricsExplorerViewRequestParamsRT = exports.getMetricsExplorerViewUrl = exports.METRICS_EXPLORER_VIEW_URL_ENTITY = exports.METRICS_EXPLORER_VIEW_URL = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/Either");
var _metrics_explorer_views = require("../../../metrics_explorer_views");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_EXPLORER_VIEW_URL = exports.METRICS_EXPLORER_VIEW_URL = '/api/infra/metrics_explorer_views';
const METRICS_EXPLORER_VIEW_URL_ENTITY = exports.METRICS_EXPLORER_VIEW_URL_ENTITY = `${METRICS_EXPLORER_VIEW_URL}/{metricsExplorerViewId}`;
const getMetricsExplorerViewUrl = metricsExplorerViewId => [METRICS_EXPLORER_VIEW_URL, metricsExplorerViewId].filter(Boolean).join('/');
exports.getMetricsExplorerViewUrl = getMetricsExplorerViewUrl;
const metricsExplorerViewIdRT = new rt.Type('MetricsExplorerViewId', rt.string.is, (u, c) => _Either.either.chain(rt.string.validate(u, c), id => {
  return id === '0' ? rt.failure(u, c, `The metrics explorer view with id ${id} is not configurable.`) : rt.success(id);
}), String);
const metricsExplorerViewRequestParamsRT = exports.metricsExplorerViewRequestParamsRT = rt.type({
  metricsExplorerViewId: metricsExplorerViewIdRT
});
const metricsExplorerViewRequestQueryRT = exports.metricsExplorerViewRequestQueryRT = rt.partial({
  sourceId: rt.string
});
const metricsExplorerViewResponsePayloadRT = exports.metricsExplorerViewResponsePayloadRT = rt.type({
  data: _metrics_explorer_views.metricsExplorerViewRT
});