"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogAlertsChartPreviewDataSuccessResponsePayloadRT = exports.getLogAlertsChartPreviewDataRequestPayloadRT = exports.getLogAlertsChartPreviewDataAlertParamsSubsetRT = exports.LOG_ALERTS_CHART_PREVIEW_DATA_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/logs-shared-plugin/common");
var _types = require("../../../alerting/logs/log_threshold/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ALERTS_CHART_PREVIEW_DATA_PATH = exports.LOG_ALERTS_CHART_PREVIEW_DATA_PATH = '/api/infra/log_alerts/chart_preview_data';
const pointRT = rt.type({
  timestamp: rt.number,
  value: rt.number
});
const serieRT = rt.type({
  id: rt.string,
  points: rt.array(pointRT)
});
const seriesRT = rt.array(serieRT);
const getLogAlertsChartPreviewDataSuccessResponsePayloadRT = exports.getLogAlertsChartPreviewDataSuccessResponsePayloadRT = rt.type({
  data: rt.type({
    series: seriesRT
  })
});
// This should not have an explicit `any` return type, but it's here because its
// inferred type includes `Comparator` which is a string enum exported from
// common/alerting/logs/log_threshold/types.ts.
//
// There's a bug that's fixed in TypeScript 4.2.0 that will allow us to remove
// the `:any` from this, so remove it when that update happens.
//
// If it's removed before then you get:
//
//     x-pack/solutions/observability/plugins/infra/common/http_api/log_alerts/chart_preview_data.ts:44:14 - error TS4023:
//     Exported variable 'getLogAlertsChartPreviewDataAlertParamsSubsetRT' has or is using name 'Comparator'
//     from external module "/Users/smith/Code/kibana/x-pack/solutions/observability/plugins/infra/common/alerting/logs/log_threshold/types"
//     but cannot be named.
//
const getLogAlertsChartPreviewDataAlertParamsSubsetRT = exports.getLogAlertsChartPreviewDataAlertParamsSubsetRT = rt.intersection([rt.type({
  criteria: rt.union([_types.countCriteriaRT, rt.array(_types.countCriteriaRT)]),
  count: rt.intersection([rt.type({
    comparator: _types.ThresholdRT.props.comparator
  }), rt.partial({
    value: _types.ThresholdRT.props.value
  })]),
  timeUnit: _types.timeUnitRT,
  timeSize: _types.timeSizeRT
}), rt.partial({
  groupBy: _types.groupByRT
})]);
const getLogAlertsChartPreviewDataRequestPayloadRT = exports.getLogAlertsChartPreviewDataRequestPayloadRT = rt.type({
  data: rt.type({
    logView: _common.persistedLogViewReferenceRT,
    alertParams: getLogAlertsChartPreviewDataAlertParamsSubsetRT,
    buckets: rt.number,
    executionTimeRange: rt.union([rt.undefined, rt.type({
      gte: rt.number,
      lte: rt.number
    })])
  })
});