"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _chat_complete = require("./chat_complete");
var _connectors = require("./connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = ({
  router,
  logger,
  coreSetup
}) => {
  (0, _chat_complete.registerChatCompleteRoute)({
    router,
    coreSetup,
    logger: logger.get('chatComplete')
  });
  (0, _connectors.registerConnectorsRoute)({
    router,
    coreSetup
  });
};
exports.registerRoutes = registerRoutes;