"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerChatCompleteRoute = registerChatCompleteRoute;
var _configSchema = require("@kbn/config-schema");
var _inferenceCommon = require("@kbn/inference-common");
var _inference_client = require("../inference_client");
var _observable_into_event_source_stream = require("../util/observable_into_event_source_stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolCallSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  toolCallId: _configSchema.schema.string(),
  function: _configSchema.schema.object({
    name: _configSchema.schema.string(),
    arguments: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
  })
}));
const chatCompleteBodySchema = _configSchema.schema.object({
  connectorId: _configSchema.schema.string(),
  system: _configSchema.schema.maybe(_configSchema.schema.string()),
  tools: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    description: _configSchema.schema.string(),
    schema: _configSchema.schema.maybe(_configSchema.schema.object({
      type: _configSchema.schema.literal('object'),
      properties: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
      required: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
    }))
  }))),
  toolChoice: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_inferenceCommon.ToolChoiceType.auto), _configSchema.schema.literal(_inferenceCommon.ToolChoiceType.none), _configSchema.schema.literal(_inferenceCommon.ToolChoiceType.required), _configSchema.schema.object({
    function: _configSchema.schema.string()
  })])),
  messages: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
    role: _configSchema.schema.literal(_inferenceCommon.MessageRole.Assistant),
    content: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.literal(null)]),
    toolCalls: _configSchema.schema.maybe(toolCallSchema)
  }), _configSchema.schema.object({
    role: _configSchema.schema.literal(_inferenceCommon.MessageRole.User),
    content: _configSchema.schema.string(),
    name: _configSchema.schema.maybe(_configSchema.schema.string())
  }), _configSchema.schema.object({
    name: _configSchema.schema.string(),
    role: _configSchema.schema.literal(_inferenceCommon.MessageRole.Tool),
    toolCallId: _configSchema.schema.string(),
    response: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
    data: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
  })])),
  functionCalling: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('native'), _configSchema.schema.literal('simulated'), _configSchema.schema.literal('auto')])),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  modelName: _configSchema.schema.maybe(_configSchema.schema.string())
});
function registerChatCompleteRoute({
  coreSetup,
  router,
  logger
}) {
  async function callChatComplete({
    request,
    stream
  }) {
    const actions = await coreSetup.getStartServices().then(([coreStart, pluginsStart]) => pluginsStart.actions);
    const abortController = new AbortController();
    request.events.aborted$.subscribe(() => abortController.abort());
    const client = (0, _inference_client.createClient)({
      request,
      actions,
      logger
    });
    const {
      connectorId,
      messages,
      system,
      toolChoice,
      tools,
      functionCalling
    } = request.body;
    return client.chatComplete({
      connectorId,
      messages,
      system,
      toolChoice,
      tools,
      functionCalling,
      stream,
      abortSignal: abortController.signal
    });
  }
  router.post({
    path: '/internal/inference/chat_complete',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: {
      body: chatCompleteBodySchema
    }
  }, async (context, request, response) => {
    try {
      const chatCompleteResponse = await callChatComplete({
        request,
        stream: false
      });
      return response.ok({
        body: chatCompleteResponse
      });
    } catch (e) {
      var _e$meta$status, _e$meta, _e$code;
      return response.custom({
        statusCode: (0, _inferenceCommon.isInferenceError)(e) ? (_e$meta$status = (_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : _e$meta.status) !== null && _e$meta$status !== void 0 ? _e$meta$status : 500 : 500,
        bypassErrorFormat: true,
        body: {
          type: _inferenceCommon.InferenceTaskEventType.error,
          code: (_e$code = e.code) !== null && _e$code !== void 0 ? _e$code : 'unknown',
          message: e.message
        }
      });
    }
  });
  router.post({
    path: '/internal/inference/chat_complete/stream',
    validate: {
      body: chatCompleteBodySchema
    }
  }, async (context, request, response) => {
    const chatCompleteEvents$ = await callChatComplete({
      request,
      stream: true
    });
    return response.ok({
      body: (0, _observable_into_event_source_stream.observableIntoEventSourceStream)(chatCompleteEvents$, logger)
    });
  });
}