"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createClient = createClient;
var _inference_client = require("./inference_client");
var _bind_client = require("./bind_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createClient(options) {
  const {
    actions,
    request,
    logger
  } = options;
  const client = (0, _inference_client.createInferenceClient)({
    request,
    actions,
    logger
  });
  if ('bindTo' in options) {
    return (0, _bind_client.bindClient)(client, options.bindTo);
  } else {
    return client;
  }
}