"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatCompleteApi = createChatCompleteApi;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _adapters = require("./adapters");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createChatCompleteApi({
  request,
  actions,
  logger
}) {
  return ({
    connectorId,
    messages,
    toolChoice,
    tools,
    temperature,
    system,
    functionCalling,
    modelName,
    stream,
    abortSignal,
    metadata
  }) => {
    const inference$ = (0, _rxjs.defer)(async () => {
      return await (0, _utils.getInferenceExecutor)({
        connectorId,
        request,
        actions
      });
    }).pipe((0, _rxjs.switchMap)(executor => {
      const connectorType = executor.getConnector().type;
      const inferenceAdapter = (0, _adapters.getInferenceAdapter)(connectorType);
      const messagesWithoutData = messages.map(message => (0, _lodash.omit)(message, 'data'));
      if (!inferenceAdapter) {
        return (0, _rxjs.throwError)(() => (0, _inferenceCommon.createInferenceRequestError)(`Adapter for type ${connectorType} not implemented`, 400));
      }
      logger.debug(() => `Sending request, last message is: ${JSON.stringify((0, _lodash.last)(messagesWithoutData))}`);
      logger.trace(() => JSON.stringify({
        messages: messagesWithoutData,
        toolChoice,
        tools,
        system
      }));
      return inferenceAdapter.chatComplete({
        system,
        executor,
        messages,
        toolChoice,
        tools,
        temperature,
        logger,
        functionCalling,
        modelName,
        abortSignal,
        metadata
      });
    }), (0, _utils.chunksIntoMessage)({
      toolOptions: {
        toolChoice,
        tools
      },
      logger
    }), abortSignal ? (0, _utils.handleCancellation)(abortSignal) : _rxjs.identity);
    if (stream) {
      return inference$;
    } else {
      return (0, _utils.streamToResponse)(inference$);
    }
  };
}