"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processOpenAIStream = processOpenAIStream;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _errors = require("../../errors");
var _from_openai = require("./from_openai");
var _stream_errors = require("./stream_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processOpenAIStream() {
  return source => {
    return source.pipe((0, _rxjs.filter)(line => !!line && line !== '[DONE]'), (0, _rxjs.map)(line => {
      try {
        return JSON.parse(line);
      } catch (e) {
        throw (0, _inferenceCommon.createInferenceInternalError)(`Failed to parse line "${line}": ${e.message}`);
      }
    }), (0, _rxjs.tap)(line => {
      if ('error' in line) {
        throw (0, _stream_errors.convertStreamError)(line);
      }
      if ('choices' in line && line.choices.length && line.choices[0].finish_reason === 'length') {
        throw (0, _errors.createTokenLimitReachedError)();
      }
    }), (0, _rxjs.filter)(line => {
      return 'object' in line && line.object === 'chat.completion.chunk';
    }), (0, _rxjs.mergeMap)(chunk => {
      var _chunk$choices;
      const events = [];
      if (chunk.usage) {
        events.push((0, _from_openai.tokenCountFromOpenAI)(chunk.usage));
      }
      if ((_chunk$choices = chunk.choices) !== null && _chunk$choices !== void 0 && _chunk$choices.length) {
        events.push((0, _from_openai.chunkFromOpenAI)(chunk));
      }
      return (0, _rxjs.from)(events);
    }));
  };
}