"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRequest = void 0;
var _simulated_function_calling = require("../../simulated_function_calling");
var _openai = require("../openai");
var _providers = require("./providers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRequest = options => {
  const {
    system,
    messages,
    toolChoice,
    tools,
    simulatedFunctionCalling,
    temperature = 0,
    modelName
  } = (0, _providers.applyProviderTransforms)(options);
  let request;
  if (simulatedFunctionCalling) {
    const wrapped = (0, _simulated_function_calling.wrapWithSimulatedFunctionCalling)({
      system,
      messages,
      toolChoice,
      tools
    });
    request = {
      temperature,
      model: modelName,
      messages: (0, _openai.messagesToOpenAI)({
        system: wrapped.system,
        messages: wrapped.messages
      })
    };
  } else {
    request = {
      temperature,
      model: modelName,
      messages: (0, _openai.messagesToOpenAI)({
        system,
        messages
      }),
      tool_choice: (0, _openai.toolChoiceToOpenAI)(toolChoice),
      tools: (0, _openai.toolsToOpenAI)(tools)
    };
  }
  return request;
};
exports.createRequest = createRequest;