"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOutputCompleteEvent = isOutputCompleteEvent;
exports.isOutputEvent = isOutputEvent;
exports.isOutputUpdateEvent = isOutputUpdateEvent;
exports.withoutOutputUpdateEvents = withoutOutputUpdateEvents;
var _rxjs = require("rxjs");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Check if the provided {@link ChatCompletionEvent} is a {@link ChatCompletionChunkEvent}
 */
function isOutputCompleteEvent(event) {
  return event.type === _.OutputEventType.OutputComplete;
}

/**
 * Check if the provided {@link InferenceTaskEvent} is a {@link OutputEvent}
 */
function isOutputEvent(event) {
  return event.type === _.OutputEventType.OutputComplete || event.type === _.OutputEventType.OutputUpdate;
}

/**
 * Check if the provided {@link OutputEvent} is a {@link OutputUpdateEvent}
 */
function isOutputUpdateEvent(event) {
  return event.type === _.OutputEventType.OutputComplete;
}

/**
 * Operator filtering out the update events from the provided observable.
 */
function withoutOutputUpdateEvents() {
  return (0, _rxjs.filter)(event => event.type !== _.OutputEventType.OutputUpdate);
}