"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeDataStream = deserializeDataStream;
exports.deserializeDataStreamList = deserializeDataStreamList;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function deserializeDataStream(dataStreamFromEs, isLogsdbEnabled) {
  const {
    name,
    timestamp_field: timeStampField,
    indices,
    generation,
    status,
    template,
    ilm_policy: ilmPolicyName,
    store_size: storageSize,
    store_size_bytes: storageSizeBytes,
    maximum_timestamp: maxTimeStamp,
    metering_size_in_bytes: meteringStorageSizeBytes,
    metering_doc_count: meteringDocsCount,
    _meta,
    privileges,
    hidden,
    lifecycle,
    global_max_retention: globalMaxRetention,
    next_generation_managed_by: nextGenerationManagedBy,
    index_mode: indexMode
  } = dataStreamFromEs;
  const meteringStorageSize = meteringStorageSizeBytes !== undefined ? new _configSchema.ByteSizeValue(meteringStorageSizeBytes).toString() : undefined;
  return {
    name,
    timeStampField,
    indices: indices.map(({
      index_name: indexName,
      index_uuid: indexUuid,
      prefer_ilm: preferILM = false,
      managed_by: managedBy
    }) => ({
      name: indexName,
      uuid: indexUuid,
      preferILM,
      managedBy
    })),
    generation,
    health: status.toLowerCase(),
    // ES typically returns status in all-caps
    indexTemplateName: template,
    ilmPolicyName,
    storageSize,
    storageSizeBytes,
    maxTimeStamp,
    meteringStorageSize,
    meteringStorageSizeBytes,
    meteringDocsCount,
    _meta,
    privileges,
    hidden,
    lifecycle: {
      ...lifecycle,
      globalMaxRetention
    },
    nextGenerationManagedBy,
    indexMode: indexMode !== null && indexMode !== void 0 ? indexMode : isLogsdbEnabled && /^logs-[^-]+-[^-]+$/.test(name) ? _constants.LOGSDB_INDEX_MODE : _constants.STANDARD_INDEX_MODE
  };
}
function deserializeDataStreamList(dataStreamsFromEs, isLogsdbEnabled) {
  return dataStreamsFromEs.map(dataStream => deserializeDataStream(dataStream, isLogsdbEnabled));
}