"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../services");
var _details_page_settings_content = require("./details_page_settings_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsPageSettings = ({
  indexName
}) => {
  const {
    isLoading,
    data,
    error,
    resendRequest
  } = (0, _services.useLoadIndexSettings)(indexName);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.settings.loadingDescription",
      defaultMessage: "Loading index settings\u2026"
    }));
  }
  if (error || !data) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexDetailsSettingsError",
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.errorTitle",
        defaultMessage: "Unable to load index settings"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.errorDescription",
        defaultMessage: "We encountered an error loading settings for index {indexName}. Make sure that the index name in the URL is correct and try again.",
        values: {
          indexName
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        "data-test-subj": "indexDetailsSettingsReloadButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.reloadButtonLabel",
        defaultMessage: "Reload"
      })))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_details_page_settings_content.DetailsPageSettingsContent, {
    data: data,
    indexName: indexName,
    reloadIndexSettings: resendRequest
  });
};
exports.DetailsPageSettings = DetailsPageSettings;