"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rubyDefinition = exports.pythonDefinition = exports.phpDefinition = exports.languageDefinitions = exports.javascriptDefinition = exports.goDefinition = exports.curlDefinition = void 0;
var _searchApiPanels = require("@kbn/search-api-panels");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_NAME_PLACEHOLDER = 'index_name';
const curlDefinition = exports.curlDefinition = {
  id: _searchApiPanels.Languages.CURL,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.languages.cURL', {
    defaultMessage: 'cURL'
  }),
  iconType: 'curl.svg',
  languageStyling: 'shell',
  ingestDataIndex: ({
    apiKey,
    indexName,
    url
  }) => `curl -X POST ${url}/_bulk?pretty \\
  -H "Authorization: ApiKey ${apiKey}" \\
  -H "Content-Type: application/json" \\
  -d'
{ "index" : { "_index" : "${indexName !== null && indexName !== void 0 ? indexName : INDEX_NAME_PLACEHOLDER}" } }
{"name": "foo", "title": "bar" }
'
`
};
const javascriptDefinition = exports.javascriptDefinition = {
  id: _searchApiPanels.Languages.JAVASCRIPT,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.languages.javascript', {
    defaultMessage: 'JavaScript'
  }),
  iconType: 'javascript.svg',
  ingestDataIndex: ({
    apiKey,
    url,
    indexName
  }) => `const { Client } = require('@elastic/elasticsearch');
const client = new Client({
  node: '${url}',
  auth: {
      apiKey: '${apiKey}'
  }
});
const dataset = [
  {'name': 'foo', 'title': 'bar'},
];

// Index with the bulk helper
const result = await client.helpers.bulk({
  datasource: dataset,
  onDocument (doc) {
    return { index: { _index: '${indexName !== null && indexName !== void 0 ? indexName : 'index_name'}' }};
  }
});
console.log(result);
`
};
const goDefinition = exports.goDefinition = {
  id: _searchApiPanels.Languages.GO,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.languages.go', {
    defaultMessage: 'Go'
  }),
  iconType: 'go.svg',
  ingestDataIndex: ({
    apiKey,
    url,
    indexName
  }) => `import (
  "context"
  "fmt"
  "log"
  "strings"

  "github.com/elastic/elasticsearch-serverless-go"
)

func main() {
  cfg := elasticsearch.Config{
    Address: "${url}",
    APIKey: "${apiKey}",
  }
  es, err := elasticsearch.NewClient(cfg)
  if err != nil {
    log.Fatalf("Error creating the client: %s", err)
  }
  res, err := es.Bulk().
    Index("${indexName}").
    Raw(strings.NewReader(\`
{ "index": { "_id": "1"}}
{"name": "foo", "title": "bar"}\n\`)).
    Do(context.Background())

  fmt.Println(res, err)
}`
};
const pythonDefinition = exports.pythonDefinition = {
  id: _searchApiPanels.Languages.PYTHON,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.languages.python', {
    defaultMessage: 'Python'
  }),
  iconType: 'python.svg',
  ingestDataIndex: ({
    apiKey,
    url,
    indexName
  }) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
  "${url}",
  api_key="${apiKey}"
)

documents = [
  {"index": {"_index": "${indexName !== null && indexName !== void 0 ? indexName : INDEX_NAME_PLACEHOLDER}"}},
  {"name": "foo", "title": "bar"},
]

client.bulk(operations=documents)
`
};
const phpDefinition = exports.phpDefinition = {
  id: _searchApiPanels.Languages.PHP,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.languages.php', {
    defaultMessage: 'PHP'
  }),
  iconType: 'php.svg',
  ingestDataIndex: ({
    apiKey,
    url,
    indexName
  }) => `$client = ClientBuilder::create()
  ->setHosts(['${url}'])
  ->setApiKey('${apiKey}')
  ->build();

$params = [
'body' => [
[
'index' => [
'_index' => '${indexName !== null && indexName !== void 0 ? indexName : INDEX_NAME_PLACEHOLDER}',
'_id' => '1',
],
],
[
'name' => 'foo',
'title' => 'bar',
],
],
];

$response = $client->bulk($params);
echo $response->getStatusCode();
echo (string) $response->getBody();
`
};
const rubyDefinition = exports.rubyDefinition = {
  id: _searchApiPanels.Languages.RUBY,
  name: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.languages.ruby', {
    defaultMessage: 'Ruby'
  }),
  iconType: 'ruby.svg',
  ingestDataIndex: ({
    apiKey,
    url,
    indexName
  }) => `client = ElasticsearchServerless::Client.new(
  api_key: '${apiKey}',
  url: '${url}'
)

documents = [
  { index: { _index: '${indexName !== null && indexName !== void 0 ? indexName : INDEX_NAME_PLACEHOLDER}', data: {name: "foo", "title": "bar"} } },
]
client.bulk(body: documents)
`
};
const languageDefinitionRecords = {
  [_searchApiPanels.Languages.CURL]: curlDefinition,
  [_searchApiPanels.Languages.PYTHON]: pythonDefinition,
  [_searchApiPanels.Languages.JAVASCRIPT]: javascriptDefinition,
  [_searchApiPanels.Languages.PHP]: phpDefinition,
  [_searchApiPanels.Languages.GO]: goDefinition,
  [_searchApiPanels.Languages.RUBY]: rubyDefinition
};
const languageDefinitions = exports.languageDefinitions = Object.values(languageDefinitionRecords);