"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabAliases = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabAliases = ({
  aliases
}) => {
  if (aliases && Object.keys(aliases).length) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "aliasesTabContent"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "json"
    }, JSON.stringify(aliases, null, 2)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.aliasesTab.noAliasesTitle",
      defaultMessage: "No aliases defined."
    }),
    iconType: "pin",
    "data-test-subj": "noAliasesCallout",
    size: "s"
  });
};
exports.TabAliases = TabAliases;