"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeType = void 0;
var _react = _interopRequireDefault(require("react"));
var _lib = require("../../../../lib");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
var _shared_imports = require("../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultToggleValue = (param, field) => {
  return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
};
const RangeType = ({
  field,
  kibanaVersion
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.IndexParameter, {
    hasIndexOptions: false
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "subType"
  }, formData => {
    var _formData$subType, _formData$subType$;
    return ((_formData$subType = formData.subType) === null || _formData$subType === void 0 ? void 0 : (_formData$subType$ = _formData$subType[0]) === null || _formData$subType$ === void 0 ? void 0 : _formData$subType$.value) === 'date_range' ? /*#__PURE__*/_react.default.createElement(_field_parameters.FormatParameter, {
      defaultValue: field.source.format,
      defaultToggleValue: getDefaultToggleValue('format', field.source)
    }) : null;
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, null, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "subType"
  }, formData => {
    var _formData$subType2, _formData$subType2$;
    return ((_formData$subType2 = formData.subType) === null || _formData$subType2 === void 0 ? void 0 : (_formData$subType2$ = _formData$subType2[0]) === null || _formData$subType2$ === void 0 ? void 0 : _formData$subType2$.value) === 'date_range' ? /*#__PURE__*/_react.default.createElement(_field_parameters.LocaleParameter, {
      defaultToggleValue: getDefaultToggleValue('locale', field.source)
    }) : null;
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.CoerceNumberParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.StoreParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source)
  }), kibanaVersion.major < 8 && /*#__PURE__*/_react.default.createElement(_field_parameters.BoostParameter, {
    defaultToggleValue: getDefaultToggleValue('boost', field.source)
  })));
};
exports.RangeType = RangeType;