"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesListItem = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared = require("../../shared");
require("./component_templates_list_item.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplatesListItem = ({
  component,
  onViewDetail,
  actions,
  isSelected = false,
  dragHandleProps
}) => {
  const hasActions = actions && actions.length > 0;
  const isSelectedValue = typeof isSelected === 'function' ? isSelected(component) : isSelected;
  const isDraggable = Boolean(dragHandleProps);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('componentTemplatesListItem', {
      'componentTemplatesListItem--selected': isSelectedValue
    }),
    "data-test-subj": "item"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, isDraggable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", dragHandleProps, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "name"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => onViewDetail(component)
  }, component.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "componentTemplatesListItem__contentIndicator"
  }, /*#__PURE__*/_react.default.createElement(_shared.TemplateContentIndicator, {
    settings: component.hasSettings,
    mappings: component.hasMappings,
    aliases: component.hasAliases
  })))), hasActions && !isSelectedValue && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, actions.map((action, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: action.label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: action.icon,
    onClick: () => action.handler(component),
    "data-test-subj": `action-${action.icon}`,
    "aria-label": action.label
  }))))))), isSelectedValue && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "componentTemplatesListItem__checkIcon",
    type: "check",
    color: "success"
  }));
};
exports.ComponentTemplatesListItem = ComponentTemplatesListItem;