"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadonlyField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _learn_more_link = require("../../learn_more_link");
var _described_form_row = require("../../described_form_row");
var _shared_imports = require("../../../../../../shared_imports");
var _i18n_texts = require("../../../i18n_texts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReadonlyField = ({
  phase
}) => {
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_described_form_row.ToggleFieldWithDescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n_texts.i18nTexts.editPolicy.readonlyLabel),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.readonlyDescription",
      defaultMessage: "Enable to make the index and index metadata read only, disable to allow writes and metadata changes."
    }), ' ', /*#__PURE__*/_react.default.createElement(_learn_more_link.LearnMoreLink, {
      docPath: docLinks.links.elasticsearch.ilmReadOnly
    })),
    fullWidth: true,
    titleSize: "xs",
    switchProps: {
      'data-test-subj': `${phase}-readonlySwitch`,
      path: `_meta.${phase}.readonlyEnabled`
    }
  }, /*#__PURE__*/_react.default.createElement("div", null));
};
exports.ReadonlyField = ReadonlyField;