"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCreateImageAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _constants = require("../image_embeddable/constants");
var _kibana_services = require("../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const parentApiIsCompatible = async parentApi => {
  const {
    apiCanAddNewPanel
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiCanAddNewPanel(parentApi) ? parentApi : undefined;
};
const registerCreateImageAction = () => {
  _kibana_services.uiActionsService.registerAction({
    id: _constants.ADD_IMAGE_EMBEDDABLE_ACTION_ID,
    getIconType: () => 'image',
    order: 20,
    isCompatible: async ({
      embeddable: parentApi
    }) => {
      return Boolean(await parentApiIsCompatible(parentApi));
    },
    execute: async ({
      embeddable: parentApi
    }) => {
      const canAddNewPanelParent = await parentApiIsCompatible(parentApi);
      if (!canAddNewPanelParent) throw new _public2.IncompatibleActionError();
      const {
        openImageEditor
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/image_editor/open_image_editor')));
      try {
        const imageConfig = await openImageEditor({
          parentApi: canAddNewPanelParent
        });
        canAddNewPanelParent.addNewPanel({
          panelType: _constants.IMAGE_EMBEDDABLE_TYPE,
          initialState: {
            imageConfig
          }
        });
      } catch {
        // swallow the rejection, since this just means the user closed without saving
      }
    },
    grouping: [_public.ADD_PANEL_ANNOTATION_GROUP],
    getDisplayName: () => _i18n.i18n.translate('imageEmbeddable.imageEmbeddableFactory.displayName', {
      defaultMessage: 'Image'
    })
  });
  _kibana_services.uiActionsService.attachAction(_public2.ADD_PANEL_TRIGGER, _constants.ADD_IMAGE_EMBEDDABLE_ACTION_ID);
  if (_kibana_services.uiActionsService.hasTrigger('ADD_CANVAS_ELEMENT_TRIGGER')) {
    // Because Canvas is not enabled in Serverless, this trigger might not be registered - only attach
    // the create action if the Canvas-specific trigger does indeed exist.
    _kibana_services.uiActionsService.attachAction('ADD_CANVAS_ELEMENT_TRIGGER', _constants.ADD_IMAGE_EMBEDDABLE_ACTION_ID);
  }
};
exports.registerCreateImageAction = registerCreateImageAction;