"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStepLocationPath = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// regex matches everything between an opening and a closing curly braces
// and the braces themselves
const paramsWithBraces = /\{(.*?)\}/g;
// regex matches both curly braces
const curlyBraces = /[\{\}]/g;
const getStepLocationPath = (path, pluginState) => {
  var _pluginState$activeGu;
  if ((_pluginState$activeGu = pluginState.activeGuide) !== null && _pluginState$activeGu !== void 0 && _pluginState$activeGu.params) {
    let dynamicPath = path;
    const matchedParams = path.match(paramsWithBraces);
    if (matchedParams) {
      for (const param of matchedParams) {
        var _pluginState$activeGu2;
        const paramWithoutBraces = param.replace(curlyBraces, '');
        dynamicPath = dynamicPath.replace(`${param}`, (_pluginState$activeGu2 = pluginState.activeGuide) === null || _pluginState$activeGu2 === void 0 ? void 0 : _pluginState$activeGu2.params[paramWithoutBraces]);
      }
      return dynamicPath;
    }
  }
  return path;
};
exports.getStepLocationPath = getStepLocationPath;