"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VennDiagram = VennDiagram;
var _react = _interopRequireDefault(require("react"));
var _vennjs = require("./vennjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRadius(area) {
  return Math.sqrt(area / Math.PI);
}
function VennDiagram({
  leftValue,
  rightValue,
  overlap
}) {
  const leftRadius = getRadius(leftValue);
  const rightRadius = getRadius(rightValue);
  const maxRadius = Math.max(leftRadius, rightRadius);
  const imageHeight = maxRadius * 2;
  const imageWidth = maxRadius * 4;
  const leftCenter = leftRadius;
  const rightCenter = leftCenter + (0, _vennjs.distanceFromIntersectArea)(leftRadius, rightRadius, overlap);

  // blank width is what's left after the right venn circle - it is used as padding
  const blankWidth = imageWidth - (rightCenter + rightRadius);
  const padding = blankWidth / 2;
  const viewBoxDims = `0 0 ${imageWidth} ${imageHeight}`;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: 100,
    height: 60,
    viewBox: viewBoxDims
  }, /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("circle", {
    cx: leftCenter + padding,
    cy: maxRadius,
    r: leftRadius,
    className: "gphVennDiagram__left"
  }), /*#__PURE__*/_react.default.createElement("circle", {
    cx: rightCenter + padding,
    cy: maxRadius,
    r: rightRadius,
    className: "gphVennDiagram__right"
  }))));
}