"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveModal = SaveModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SaveModal({
  onSave,
  onClose,
  title,
  description,
  showCopyOnSave,
  savePolicy,
  hasData
}) {
  const [newDescription, setDescription] = (0, _react.useState)(description);
  const [dataConsent, setDataConsent] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
    onSave: props => {
      onSave({
        ...props,
        newDescription,
        dataConsent
      });
    },
    onClose: onClose,
    title: title,
    showCopyOnSave: showCopyOnSave,
    objectType: _i18n.i18n.translate('xpack.graph.topNavMenu.save.objectType', {
      defaultMessage: 'graph'
    }),
    showDescription: false,
    options: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.graph.topNavMenu.save.descriptionInputLabel', {
        defaultMessage: 'Description'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      "data-test-subj": "dashboardDescription",
      value: newDescription,
      onChange: e => {
        setDescription(e.target.value);
      },
      fullWidth: true,
      rows: 5
    })), savePolicy === 'configAndDataWithConsent' && hasData && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: "",
      helpText: _i18n.i18n.translate('xpack.graph.topNavMenu.save.saveConfigurationOnlyWarning', {
        defaultMessage: 'Without this setting, the data in this workspace will be cleared and only the configuration will be saved.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: "graphDataConsent",
      label: _i18n.i18n.translate('xpack.graph.topNavMenu.save.saveGraphContentCheckboxLabel', {
        defaultMessage: 'Save graph content'
      }),
      checked: dataConsent,
      onChange: e => {
        setDataConsent(e.target.checked);
      }
    })), savePolicy === 'config' && hasData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "graphNoDataSavedMsg"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.graph.topNavMenu.save.saveConfigurationOnlyText', {
      defaultMessage: 'The data in this workspace will be cleared and only the configuration will be saved.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  });
}