/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(()=>{var e={164:(e,t,r)=>{"use strict";r.r(t),r.d(t,{plugin:()=>u});var s=r(915);class LicenseChecker{constructor(e){(0,s.default)(this,"subscription",void 0),(0,s.default)(this,"state",{valid:!1,message:"unknown"}),this.subscription=e.subscribe((e=>{this.state=(e=>{const t=e.check("globalSearch","basic");switch(t.state){case"expired":return{valid:!1,message:"expired"};case"invalid":return{valid:!1,message:"invalid"};case"unavailable":return{valid:!1,message:"unavailable"};case"valid":return{valid:!0};default:throw new Error(`Invalid license state: ${t.state}`)}})(e)}))}getState(){return this.state}clean(){this.subscription.unsubscribe()}}const i=__kbnSharedDeps__.Rxjs,a=__kbnSharedDeps__.Lodash,n=__kbnSharedDeps__.Moment,o=__kbnSharedDeps__.KbnI18n;class GlobalSearchFindError extends Error{static invalidLicense(e){return new GlobalSearchFindError("invalid-license",e)}constructor(e,t){super(t),this.type=e,Object.setPrototypeOf(this,GlobalSearchFindError.prototype)}}class TakeInArray{constructor(e){if(this.total=e,this.total<0)throw new Error("Cannot take a negative number of items")}call(e,t){return t.subscribe(new TakeInArraySubscriber(e,this.total))}}class TakeInArraySubscriber extends i.Subscriber{constructor(e,t){super(e),(0,s.default)(this,"current",0),this.total=t}_next(e){const t=this.total-this.current;t>e.length?(this.destination.next(e),this.current+=e.length):(this.destination.next(e.slice(0,t)),this.destination.complete(),this.unsubscribe())}}const c=(e,t)=>"string"==typeof e?e.startsWith("/")?t.prepend(e):e:e.prependBasePath?t.prepend(e.path):e.path,l=__kbnSharedDeps__.Uuid,h="globalSearch:defaultPref",p=()=>{};class SearchService{constructor(){(0,s.default)(this,"providers",new Map),(0,s.default)(this,"config",void 0),(0,s.default)(this,"http",void 0),(0,s.default)(this,"maxProviderResults",40),(0,s.default)(this,"licenseChecker",void 0),(0,s.default)(this,"serverTypes",void 0)}setup({config:e,maxProviderResults:t=40}){return this.config=e,this.maxProviderResults=t,{registerResultProvider:e=>{if(this.providers.has(e.id))throw new Error(`trying to register duplicate provider: ${e.id}`);this.providers.set(e.id,e)}}}start({http:e,licenseChecker:t}){return this.http=e,this.licenseChecker=t,{find:(e,t)=>this.performFind(e,t),getSearchableTypes:()=>this.getSearchableTypes()}}async getSearchableTypes(){const e=(await Promise.all([...this.providers.values()].map((e=>e.getSearchableTypes())))).flat();return this.serverTypes||(this.serverTypes=await(async e=>{const{types:t}=await e.get("/internal/global_search/searchable_types");return t})(this.http)),(0,a.uniq)([...e,...this.serverTypes])}performFind(e,t){var r;const s=this.licenseChecker.getState();if(!s.valid)return(0,i.throwError)(GlobalSearchFindError.invalidLicense(o.i18n.translate("xpack.globalSearch.find.invalidLicenseError",{defaultMessage:"GlobalSearch API is disabled because of invalid license state: {errorMessage}",values:{errorMessage:s.message}})));const a=(0,n.duration)(this.config.search_timeout).asMilliseconds(),u=(0,i.timer)(a).pipe((0,i.map)(p)),d=t.aborted$?(0,i.merge)(t.aborted$,u):u,b=null!==(r=t.preference)&&void 0!==r?r:((e=window.sessionStorage)=>{let t=e.getItem(h);return t||(t=(0,l.v4)(),e.setItem(h,t),t)})(),g={...t,preference:b,maxResults:this.maxProviderResults,aborted$:d},v=e=>((e,t)=>({...e,url:c(e.url,t)}))(e,this.http.basePath),f=((e,t,{preference:r,aborted$:s})=>{var a;let n;return s&&(n=new AbortController,s.subscribe((()=>{n.abort()}))),(0,i.from)(e.post("/internal/global_search/find",{body:JSON.stringify({params:t,options:{preference:r}}),signal:null===(a=n)||void 0===a?void 0:a.signal})).pipe((0,i.takeUntil)(null!=s?s:i.EMPTY),(0,i.map)((e=>e.results)))})(this.http,e,{preference:b,aborted$:d}).pipe((0,i.catchError)((()=>i.EMPTY))),S=[...this.providers.values()].map((t=>{return t.find(e,g).pipe((0,i.catchError)((()=>i.EMPTY)),(r=this.maxProviderResults,function(e){return 0===r?i.EMPTY:e.lift(new TakeInArray(r))}),(0,i.takeUntil)(d),(0,i.map)((e=>e.map((e=>v(e))))));var r}));return(0,i.merge)(...S,f).pipe((0,i.map)((e=>({results:e}))))}}class GlobalSearchPlugin{constructor(e){(0,s.default)(this,"config",void 0),(0,s.default)(this,"licenseChecker",void 0),(0,s.default)(this,"searchService",new SearchService),this.config=e.config.get()}setup(e){const{registerResultProvider:t}=this.searchService.setup({config:this.config});return{registerResultProvider:t}}start({http:e},{licensing:t}){this.licenseChecker=new LicenseChecker(t.license$);const{find:r,getSearchableTypes:s}=this.searchService.start({http:e,licenseChecker:this.licenseChecker});return{find:r,getSearchableTypes:s}}stop(){this.licenseChecker&&this.licenseChecker.clean()}}const u=e=>new GlobalSearchPlugin(e)},24:(e,t,r)=>{r.p=window.__kbnPublicPath__.globalSearch},915:(e,t,r)=>{e.exports=r(497)(67493)},497:e=>{"use strict";e.exports=__kbnSharedDeps_npm__}},t={};function r(s){var i=t[s];if(void 0!==i)return i.exports;var a=t[s]={exports:{}};return e[s](a,a.exports,r),a.exports}r.d=(e,t)=>{for(var s in t)r.o(t,s)&&!r.o(e,s)&&Object.defineProperty(e,s,{enumerable:!0,get:t[s]})},r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),r.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},(()=>{var e;r.g.importScripts&&(e=r.g.location+"");var t=r.g.document;if(!e&&t&&(t.currentScript&&"SCRIPT"===t.currentScript.tagName.toUpperCase()&&(e=t.currentScript.src),!e)){var s=t.getElementsByTagName("script");if(s.length)for(var i=s.length-1;i>-1&&(!e||!/^http(s?):/.test(e));)e=s[i--].src}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),r.p=e})(),r(24),__kbnBundles__.define("plugin/globalSearch/public",r,164)})();