"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchServerResults = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetch the server-side results from the GS internal HTTP API.
 *
 * @remarks
 * Though this function returns an Observable, the current implementation is not streaming
 * results from the server. All results will be returned in a single batch when
 * all server-side providers are completed.
 */
const fetchServerResults = (http, params, {
  preference,
  aborted$
}) => {
  var _controller;
  let controller;
  if (aborted$) {
    controller = new AbortController();
    aborted$.subscribe(() => {
      controller.abort();
    });
  }
  return (0, _rxjs.from)(http.post('/internal/global_search/find', {
    body: JSON.stringify({
      params,
      options: {
        preference
      }
    }),
    signal: (_controller = controller) === null || _controller === void 0 ? void 0 : _controller.signal
  })).pipe((0, _rxjs.takeUntil)(aborted$ !== null && aborted$ !== void 0 ? aborted$ : _rxjs.EMPTY), (0, _rxjs.map)(response => response.results));
};
exports.fetchServerResults = fetchServerResults;