"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTagList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_TAGS_TO_SHOW = 3;
const TagListWrapper = ({
  children
}) => /*#__PURE__*/_react.default.createElement("ul", {
  className: "kbnSearchOption__tagsList",
  "aria-label": _i18n.i18n.translate('xpack.globalSearchBar.searchBar.optionTagListAriaLabel', {
    defaultMessage: 'Tags'
  })
}, children);
const buildListItem = ({
  color,
  name,
  id
}) => {
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "kbnSearchOption__tagsListItem",
    key: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color
  }, name));
};
const ResultTagList = ({
  tags,
  searchTagIds
}) => {
  const showOverflow = tags.length > MAX_TAGS_TO_SHOW;
  if (!showOverflow) {
    return /*#__PURE__*/_react.default.createElement(TagListWrapper, null, tags.map(buildListItem));
  }

  // float searched tags to the start of the list, actual order doesn't matter
  tags.sort(a => {
    if (searchTagIds.find(id => id === a.id)) return -1;
    return 1;
  });
  const overflowList = tags.splice(MAX_TAGS_TO_SHOW);
  const overflowMessage = _i18n.i18n.translate('xpack.globalSearchBar.searchbar.overflowTagsAriaLabel', {
    defaultMessage: '{n} more {n, plural, one {tag} other {tags}}: {tags}',
    values: {
      n: overflowList.length,
      // @ts-ignore-line
      tags: overflowList.map(({
        name
      }) => name)
    }
  });
  return /*#__PURE__*/_react.default.createElement(TagListWrapper, null, tags.map(buildListItem), /*#__PURE__*/_react.default.createElement("li", {
    className: "kbnSearchOption__tagsListItem",
    "aria-label": overflowMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: overflowMessage
  }, "+", overflowList.length)));
};
exports.ResultTagList = ResultTagList;