"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sort = exports.isMac = exports.blurEvent = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* @internal */
const isMac = exports.isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;

/* @internal */
const blurEvent = exports.blurEvent = new FocusEvent('focusout', {
  bubbles: true
});
const sortByScore = (a, b) => {
  if (a.score < b.score) return 1;
  if (a.score > b.score) return -1;
  return 0;
};
const sortByTitle = (a, b) => {
  const titleA = a.title.toUpperCase(); // ignore upper and lowercase
  const titleB = b.title.toUpperCase(); // ignore upper and lowercase
  if (titleA < titleB) return -1;
  if (titleA > titleB) return 1;
  return 0;
};

/* @internal */
const sort = exports.sort = {
  byScore: sortByScore,
  byTitle: sortByTitle
};