"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._getFieldsToIncludeEncryptedSO = void 0;
exports.patchUpdateDataWithRequireEncryptedAADFields = patchUpdateDataWithRequireEncryptedAADFields;
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const _getFieldsToIncludeEncryptedSO = exports._getFieldsToIncludeEncryptedSO = (0, _lodash.once)(() => {
  const res = new Set([..._saved_objects.OUTPUT_ENCRYPTED_FIELDS.values()].map(field => field.key));
  for (const field of Object.keys((0, _saved_objects.getSavedObjectTypes)()[_constants.OUTPUT_SAVED_OBJECT_TYPE].mappings.properties)) {
    if (_saved_objects.OUTPUT_INCLUDE_AAD_FIELDS.has(field)) {
      res.add(field);
    }
  }
  return [...res.values()];
});

/**
 * Patch update data to make sure we do not break encrypted field
 * allow_edit and secrets field are not excluded from AAD, we cannot change this anymore,
 * we need to make sure each time those fields are changed encrypted field are changed too.
 */
function patchUpdateDataWithRequireEncryptedAADFields(updateData, originalOutput) {
  const encryptedOrIncludedinAADFields = _getFieldsToIncludeEncryptedSO();
  if (!encryptedOrIncludedinAADFields.some(field => Object.hasOwn(updateData, field))) {
    return updateData;
  }
  for (const field of encryptedOrIncludedinAADFields) {
    if (!Object.hasOwn(updateData, field) && Object.hasOwn(originalOutput, field)) {
      // @ts-expect-error
      updateData[field] = originalOutput[field];
    }
  }
  return updateData;
}